//
//								EJEMPLO 2
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Control de los leds conectados a RB0 y RB1 desde el interruptor RA0. 
//RB0 refleja el estado de RA0, RB1 el complemento de RA0

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io(A)
#use fast_io(B)

main()
{
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0b00111111);  		// RA0 se configura como entradas
  	set_tris_b(0b11111100); 		// RB0 y RB1 se configuran como salidas

 	while(1)
    if(input(PIN_A0))         		// Leer RA0 y preguntar por su valor
    {                         	   // RA0 es 1
      output_high(PIN_B0);         // Poner RB0 a 1
      output_low(PIN_B1);         // Poner RB1 a 0
    }
    else
    {                           	// RA0 es 0
      output_low(PIN_B0);         // Poner RB0 a 0
      output_high(PIN_B1);         // Poner RB1 a 1
    }		
}
